/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.linker;

import filenet.vw.apps.linker.VWLinkerConstants;
import filenet.vw.apps.linker.VWLinkerLaunchPropertyDialog;
import filenet.vw.apps.linker.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocClass;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.toolkit.IVWIDMLink;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class VWLinkerDocPropertyDialog
extends VWModalDialog
implements ActionListener {
    protected static final int STATUS_OK = 0;
    protected static final int STATUS_CANCEL = 1;
    protected JLabel m_docClassNameLabel = new JLabel();
    protected JTextField m_wfTitleTextField = new JTextField();
    protected JTextField m_linkNameTextField = new JTextField();
    protected JComboBox m_wfVersionComboBox = null;
    protected JTextField m_wfSubjectTextField = new JTextField();
    protected JComboBox m_launchTypeComboBox = null;
    protected String m_launchCondition = null;
    protected JButton m_OKButton = new JButton(VWResource.OK);
    protected JButton m_cancelButton = new JButton(VWResource.Cancel);
    protected JButton m_helpButton = new JButton(VWResource.Help);
    protected JButton m_browseButton = new JButton(VWResource.Browse);
    protected JButton m_conditionButton = new JButton(VWResource.Condition);
    protected Frame m_parentFrame = null;
    protected boolean m_frameSizeAdjusted = false;
    protected int m_retStatus = 1;
    protected int m_linkType;
    protected int m_eventType = 1;
    protected String m_expression = "";
    protected IVWIDMDocument m_document = null;
    protected IVWIDMDocClass m_docClass = null;
    protected IVWIDMDocument m_wfDefDoc = null;
    protected IVWIDMLibrary m_library = null;
    protected Font m_boldFont = null;
    private boolean m_browseStarted = false;

    public VWLinkerDocPropertyDialog(Frame parent) {
        super(parent);
        this.m_parentFrame = parent;
    }

    public void init(IVWIDMLibrary lib, IVWIDMDocument document) {
        try {
            this.m_linkType = 2;
            this.m_launchTypeComboBox = new JComboBox<String>(VWLinkerConstants.DOC_LAUNCH_TYPES);
            this.m_library = lib;
            this.m_document = document;
            this.m_docClass = document.getDocClass();
            this.init();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(IVWIDMLibrary lib, IVWIDMDocClass docClass) {
        try {
            this.m_linkType = 1;
            this.m_launchTypeComboBox = new JComboBox<String>(VWLinkerConstants.DOCCLASS_LAUNCH_TYPES);
            this.m_library = lib;
            this.m_docClass = docClass;
            this.init();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(IVWIDMLibrary lib, IVWIDMDocument document, IVWIDMLink link) throws Exception {
        this.m_linkType = 2;
        this.m_launchTypeComboBox = new JComboBox<String>(VWLinkerConstants.DOC_LAUNCH_TYPES);
        this.m_library = lib;
        this.m_document = document;
        this.m_docClass = document.getDocClass();
        this.init();
        this.setupLink(link);
    }

    public void init(IVWIDMLibrary lib, IVWIDMDocClass docClass, IVWIDMLink link) throws Exception {
        this.m_linkType = 1;
        this.m_launchTypeComboBox = new JComboBox<String>(VWLinkerConstants.DOCCLASS_LAUNCH_TYPES);
        this.m_library = lib;
        this.m_docClass = docClass;
        this.init();
        this.setupLink(link);
    }

    private void init() {
        try {
            this.setTitle(VWResource.eProcessLinkProperty);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            Dimension dim = VWStringUtils.stringToDimension(VWResource.DocLinkPropertyDialogDim);
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim);
            this.setVisible(false);
            this.getContentPane().add((Component)this.createMiddlePanel(), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(this.m_parentFrame);
            this.m_launchTypeComboBox.setSelectedItem(VWResource.Manual);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setupWfDef(String wfDefId) throws Exception {
        try {
            this.m_wfDefDoc = this.m_library.getDocument(wfDefId);
            this.setupWfVersion(this.m_wfDefDoc);
        }
        catch (Exception ex) {
            System.out.println(VWResource.FailedGetWfDef.toString(wfDefId));
            throw ex;
        }
    }

    private void setupWfVersion(IVWIDMDocument wfDefDoc) {
        try {
            String wfDefId = wfDefDoc.getIdWithVer();
            int iX = wfDefId.lastIndexOf(58);
            this.m_wfVersionComboBox.removeAllItems();
            IVWIDMItem[] verList = wfDefDoc.list(false);
            for (int i = 0; i < verList.length; ++i) {
                String docId = verList[i].getId();
                iX = docId.lastIndexOf(58);
                this.m_wfVersionComboBox.addItem(docId.substring(iX + 1));
            }
            this.m_wfVersionComboBox.setSelectedItem(wfDefId.substring(iX + 1));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setupLink(IVWIDMLink link) throws Exception {
        this.m_wfTitleTextField.setText(link.getWfTitle());
        this.m_linkNameTextField.setText(link.getName());
        this.setupWfDef(link.getWflDocID());
        this.m_wfSubjectTextField.setText(link.getSubject());
        this.m_launchCondition = link.getExpression();
        switch (link.getEventType()) {
            case 0: {
                this.m_launchTypeComboBox.setSelectedItem(VWResource.Manual);
                break;
            }
            case 2: {
                this.m_launchTypeComboBox.setSelectedItem(VWResource.OnAdd);
                break;
            }
            case 1: {
                this.m_launchTypeComboBox.setSelectedItem(VWResource.OnCheckin);
            }
        }
    }

    protected JPanel createMiddlePanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(4, 4, 4, 4);
            Font aFont = this.getFont();
            Font boldFont = new Font(aFont.getName(), 1, aFont.getSize());
            int rowId = 0;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            JLabel docLabel = null;
            if (this.m_linkType == 2) {
                docLabel = new JLabel(VWResource.DocumentName, 2);
            } else if (this.m_linkType == 1) {
                docLabel = new JLabel(VWResource.DocumentClass, 2);
            }
            mainPanel.add((Component)docLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 2;
            if (this.m_linkType == 2) {
                this.m_docClassNameLabel.setText(this.m_document.getLabel());
            } else {
                this.m_docClassNameLabel.setText(this.m_docClass.getName());
            }
            this.m_docClassNameLabel.setFont(boldFont);
            mainPanel.add((Component)this.m_docClassNameLabel, gbConst);
            gbConst.gridx = 0;
            ++rowId;
            gbConst.gridy = rowId++;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel linkNameLabel = new JLabel(VWResource.s_label.toString(VWResource.LinkNameLabel), 2);
            mainPanel.add((Component)linkNameLabel, gbConst);
            this.m_linkNameTextField.addActionListener(this);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 2;
            mainPanel.add((Component)this.m_linkNameTextField, gbConst);
            gbConst.gridx = 0;
            gbConst.gridy = rowId++;
            gbConst.gridwidth = 0;
            gbConst.weightx = 1.0;
            mainPanel.add((Component)new JSeparator(), gbConst);
            gbConst.gridx = 0;
            gbConst.gridy = rowId++;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel workflowTitleLabel = new JLabel(VWResource.s_label.toString(VWResource.WorkflowTitleLabel), 2);
            mainPanel.add((Component)workflowTitleLabel, gbConst);
            this.m_wfTitleTextField.setEnabled(false);
            this.m_wfTitleTextField.setEditable(false);
            this.m_wfTitleTextField.addActionListener(this);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 2;
            mainPanel.add((Component)this.m_wfTitleTextField, gbConst);
            gbConst.gridx = 3;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            mainPanel.add((Component)this.m_browseButton, gbConst);
            this.m_browseButton.addActionListener(this);
            gbConst.gridx = 0;
            gbConst.gridy = rowId++;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel workflowVersionLabel = new JLabel(VWResource.s_label.toString(VWResource.WorkflowVersionLabel), 2);
            mainPanel.add((Component)workflowVersionLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 1;
            this.m_wfVersionComboBox = new JComboBox();
            mainPanel.add((Component)this.m_wfVersionComboBox, gbConst);
            gbConst.gridx = 0;
            gbConst.gridy = rowId++;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel workfloSubjectLabel = new JLabel(VWResource.s_label.toString(VWResource.WorkflowSubjectLabel), 2);
            mainPanel.add((Component)workfloSubjectLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 2;
            mainPanel.add((Component)this.m_wfSubjectTextField, gbConst);
            this.m_wfSubjectTextField.addActionListener(this);
            gbConst.gridx = 0;
            gbConst.gridy = rowId++;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            mainPanel.add((Component)new JSeparator(), gbConst);
            gbConst.gridx = 0;
            gbConst.gridy = rowId;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel launchTypeLabel = new JLabel(VWResource.s_label.toString(VWResource.LaunchType), 2);
            mainPanel.add((Component)launchTypeLabel, gbConst);
            gbConst.gridx = 1;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 2;
            mainPanel.add((Component)this.m_launchTypeComboBox, gbConst);
            this.m_launchTypeComboBox.addActionListener(this);
            gbConst.gridx = 3;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            mainPanel.add((Component)this.m_conditionButton, gbConst);
            this.m_conditionButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(4, 4, 4, 4);
            this.m_OKButton.setSelected(true);
            this.m_cancelButton.setSelected(false);
            this.m_helpButton.setSelected(false);
            mainPanel.add((Component)this.m_OKButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_OKButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public void disableWFEditing() {
        this.m_wfTitleTextField.setEditable(false);
        this.m_wfVersionComboBox.setEnabled(false);
        this.m_browseButton.setEnabled(false);
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_browseButton) {
            this.browseWorkflowDefinition();
        } else if (obj == this.m_conditionButton) {
            this.performEditLaunchCondition();
        } else if (obj == this.m_cancelButton) {
            this.m_retStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_OKButton) {
            this.performOKAction();
        } else if (obj == this.m_helpButton) {
            if (this.m_linkType == 2) {
                VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkerwfproperty.htm");
            } else if (this.m_linkType == 1) {
                VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkerdocclassproperty.htm");
            } else if (this.m_linkType == 3) {
                VWHelp.displayPage(VWHelp.Help_eProcess_Doc + "link/vwlinkerwfproperty.htm");
            }
        }
    }

    public String getWfDefDocId() {
        String docId = this.m_wfDefDoc.getId();
        int iX = docId.lastIndexOf(58);
        if (iX < 0) {
            return docId + ":" + (String)this.m_wfVersionComboBox.getSelectedItem();
        }
        return docId.substring(0, iX) + ":" + (String)this.m_wfVersionComboBox.getSelectedItem();
    }

    public String getLinkName() {
        return this.m_linkNameTextField.getText();
    }

    public String getWorkflowTitle() {
        return this.m_wfTitleTextField.getText();
    }

    public String getWorkflowSubject() {
        return this.m_wfSubjectTextField.getText();
    }

    public int getLaunchType() {
        int launchType = 0;
        String eventType = (String)this.m_launchTypeComboBox.getSelectedItem();
        if (VWStringUtils.compare(eventType, VWResource.OnAdd) == 0) {
            launchType = 2;
        } else if (VWStringUtils.compare(eventType, VWResource.OnCheckin) == 0) {
            launchType = 1;
        }
        return launchType;
    }

    public String getLaunchCondition() {
        return this.m_launchCondition;
    }

    public int getReturnStatus() {
        return this.m_retStatus;
    }

    public void performOKAction() {
        try {
            this.m_retStatus = 1;
            String linkName = this.m_linkNameTextField.getText();
            if (linkName == null || linkName.length() == 0) {
                JOptionPane.showMessageDialog(this, VWResource.LinkNameIsEmpty, null, 1, null);
                return;
            }
            if (this.m_wfDefDoc == null) {
                JOptionPane.showMessageDialog(this, VWResource.WfDefIsNotDefined, null, 1, null);
                return;
            }
            String wftitle = this.m_wfTitleTextField.getText();
            if (wftitle == null || wftitle.length() == 0) {
                JOptionPane.showMessageDialog(this, VWResource.TitleCanNotBeNull, null, 1, null);
                return;
            }
            String subject = this.m_wfSubjectTextField.getText();
            if (subject == null || subject.length() == 0) {
                JOptionPane.showMessageDialog(this, VWResource.SubjectCanNotBeNull, null, 1, null);
                return;
            }
            this.m_retStatus = 0;
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void performEditLaunchCondition() {
        try {
            String launchType = (String)this.m_launchTypeComboBox.getSelectedItem();
            VWLinkerLaunchPropertyDialog launchProperty = new VWLinkerLaunchPropertyDialog(this.m_parentFrame, this.m_docClass.getPropertyDescriptions(), launchType);
            launchProperty.setLaunchCondition(this.m_launchCondition);
            launchProperty.setVisible(true);
            if (launchProperty.getReturnStatus() == 0) {
                this.m_launchCondition = launchProperty.getLaunchCondition();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void browseWorkflowDefinition() {
        try {
            IVWIDMDialog browserDialog = VWIDMBaseFactory.instance().getWFDefBrowseDialogForLink(this.m_browseStarted ? this.m_wfDefDoc : null, null, this.m_library.getId());
            if (browserDialog.showDialog(this.m_parentFrame) == 0) {
                this.m_wfDefDoc = (IVWIDMDocument)browserDialog.getSelectedItem();
                if (this.m_wfDefDoc != null) {
                    this.m_browseStarted = true;
                    this.m_wfTitleTextField.setText(this.m_wfDefDoc.getLabel());
                    this.setupWfVersion(this.m_wfDefDoc);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

